from get_embedding import get_azure_llm_emb
import torch
from sentence_transformers import util

# Uses embedding matching for most relevant string extraction
def retrieve_top_similar_strings(target_string : str, string_list : list, k : int = 1)-> list[str]:
    list_to_pass = string_list + [target_string]
    emb_list = get_azure_llm_emb(list_to_pass)
    if not emb_list:
        return None
    string_embeddings = torch.tensor(emb_list[:-1])
    target_embedding = torch.tensor(emb_list[-1])
    # Calculate cosine similarities between the target and all strings
    similarities = util.pytorch_cos_sim(target_embedding, string_embeddings)[0]
    # Get the indices of the top-3 most similar strings
    top_indices = similarities.argsort(descending=True)[:k]
    return top_indices.tolist()

def get_oai_simvalue(target_string: str, string_list: list):
    list_to_pass = string_list + [target_string]
    emb_list = get_azure_llm_emb(list_to_pass)
    if not emb_list:
        return None
    string_embeddings = torch.tensor(emb_list[:-1])
    target_embedding = torch.tensor(emb_list[-1])
    # Calculate cosine similarities between the target and all strings
    similarities = util.pytorch_cos_sim(target_embedding, string_embeddings)[0]
    return similarities.tolist()